/* mdNameExample.c
 *
 * Melissa Data mdName API for C++ Windows/Linux/Solaris
 * Copyright 1993-2007 Melissa Data Corporation.
 */

/********************************************************************************
If you should have any comments, suggestions or improvements to these samples,
we welcome you to contact us at SampleCode@melissadata.com also please visit our
developers bulletin board at forum.melissadata.com.
********************************************************************************/

#include <stdio.h>

#define mdCFORCE
#include "mdName.h"

/* Change the following lines to reflect your installation location */
/*   of the mdName API and the license string:                      */
#define dFILELOC "C:\\Program Files\\Melissa DATA\\DQT\\Data"
	/********************** LICENSE STRINGS **********************
	*     To unlock the full functionality of Name Object,       *
	*     	     Or to obtain a Demo License String              *
	* please call a sales representative at 1-800-MELISSA ext. 3 *
	*         (1-800-635-4772 x3) for a license string.          *
	**************************************************************/
#define dLICENSE "DEMO"

int main(int Argc,char *Argv) {
	char FullName[128];
	int Record=0;
	FILE *File;
	mdName Name;
	char *resultsString;

	Argc;
	Argv;

	/* Create and initialize the API: */
	Name=mdNameCreate();
	if (!mdNameSetLicenseString(Name,dLICENSE)) {
		printf("Error setting License to \"%s\"\n",dLICENSE);
		printf("To unlock the full functionality of Name Object \n");
		printf("or to obtain a Demo License String, please call a sales representative at\n");
		printf("1-800-MELISSA ext. 3 (1-800-635-4772 x3) for a license string.\n");
		return 1;
	}

	mdNameSetPathToNameFiles(Name,dFILELOC);
	if (mdNameInitializeDataFiles(Name)!=NoError) {
		printf("Error Initializing mdName: \"%s\"\n",
			mdNameGetInitializeErrorString(Name));
		return 1;
	}


	/*Output some of the Initialization properties...*/

    printf("          NAME OBJECT VC6 EXAMPLE         \n");
    printf("==========================================\n");
    printf("        Build Number: %s\n",mdNameGetBuildNumber(Name));
    printf("       Database Date: %s\n",mdNameGetDatabaseDate(Name));
	printf("Database Expire Date: %s\n",mdNameGetDatabaseExpirationDate(Name));
	printf(" License Expire Date: %s\n\n",mdNameGetLicenseExpirationDate(Name));

	/* Set a few processing options: */
	mdNameSetPrimaryNameHint(Name,VeryLikelyFull);
	mdNameSetFirstNameSpellingCorrection(Name,1);
	mdNameSetSalutationPrefix(Name,"Dear");
	mdNameSetSalutationSuffix(Name,":");
	mdNameSetSalutationSlug(Name,"Valued Customer");

	/* Process the sample data file: */
	File=fopen("./mdName.sdf","r");
	if (File==0) {
		printf("Could not open mdName.sdf\n");
		return 1;
	}

	while (fgets(FullName,128,File)!=0) {

		/* Trim trailing CR/LFs: */
		while (FullName[strlen(FullName)-1]=='\r' || FullName[strlen(FullName)-1]=='\n')
			FullName[strlen(FullName)-1]='\x0';

		mdNameClearProperties(Name);
		mdNameSetFullName(Name,FullName);
		mdNameParse(Name);

		printf("\nRecord %d Full Name: %s\n            Gender1: %s\n"
		  "            Prefix1: %s\n        First Name1: %s\n"
		  "       Middle Name1: %s\n         Last Name1: %s\n"
		  "            Suffix1: %s\n            Gender2: %s\n"
		  "            Prefix2: %s\n        First Name2: %s\n"
		  "       Middle Name2: %s\n         Last Name2: %s\n"
		  "            Suffix2: %s\n         Salutation: %s\n\n",
		 ++Record,FullName,mdNameGetGender(Name),
		 mdNameGetPrefix(Name),mdNameGetFirstName(Name),
		 mdNameGetMiddleName(Name),mdNameGetLastName(Name),
		 mdNameGetSuffix(Name),mdNameGetGender2(Name),
		 mdNameGetPrefix2(Name),mdNameGetFirstName2(Name),
		 mdNameGetMiddleName2(Name),mdNameGetLastName2(Name),
		 mdNameGetSuffix2(Name),mdNameGetSalutation(Name));

		//Parse results are returned as a delimited string, so we need to parse them...
	    resultsString = mdNameGetResults(Name);
            printf("Results Codes...\n");
        if (strstr(resultsString,"NS01")!=0)
	        printf("NS01: There were no Errors.\n");
	    if (strstr(resultsString,"NS03")!=0)
            printf("NS03: The spelling of the FirstName field was corrected.\n");
        if (strstr(resultsString,"NS04")!=0)
            printf("NS04: The spelling of the FirstName2 field was corrected.\n");
	
        if (strstr(resultsString,"NS02")!=0)
		{
            printf("NS02: Name Parse found an Error...\n");
            if (strstr(resultsString,"NE01")!=0)
               printf("NE01: Two names were detected but the FullName string was not in a recognized format.\n");
            if (strstr(resultsString,"NE02")!=0)
               printf("NE02: Multiple first names  could not accurately genderize.\n");
            if (strstr(resultsString,"NE03")!=0)
               printf("NE03: A vulgarity was detected in the name.\n");
            if (strstr(resultsString,"NE04")!=0)
               printf("NE04: The name contained words found on the list of nuisance names (such as Mickey Mouse).\n");
            if (strstr(resultsString,"NE05")!=0)
               printf("NE05: The name contained words normally found in a company name.\n");
            if (strstr(resultsString,"NE06")!=0)
               printf("NE06: The named contained a non-alphabetic character.\n");
	}

	}
	fclose(File);

	/* Free the API: */
	mdNameDestroy(Name);
	return 0;
}